/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrGraphicsLuid")
public class OVRGraphicsLuid
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    public OVRGraphicsLuid(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRGraphicsLuid.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[8]")
    public ByteBuffer Reserved() {
        return OVRGraphicsLuid.nReserved(this.address());
    }

    @NativeType(value="char")
    public byte Reserved(int index) {
        return OVRGraphicsLuid.nReserved(this.address(), index);
    }

    public static OVRGraphicsLuid malloc() {
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRGraphicsLuid calloc() {
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRGraphicsLuid create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRGraphicsLuid create(long address) {
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)address);
    }

    @Nullable
    public static OVRGraphicsLuid createSafe(long address) {
        return address == 0L ? null : (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRGraphicsLuid.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRGraphicsLuid.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRGraphicsLuid mallocStack() {
        return OVRGraphicsLuid.mallocStack(MemoryStack.stackGet());
    }

    public static OVRGraphicsLuid callocStack() {
        return OVRGraphicsLuid.callocStack(MemoryStack.stackGet());
    }

    public static OVRGraphicsLuid mallocStack(MemoryStack stack) {
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRGraphicsLuid callocStack(MemoryStack stack) {
        return (OVRGraphicsLuid)OVRGraphicsLuid.wrap(OVRGraphicsLuid.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRGraphicsLuid.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRGraphicsLuid.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRGraphicsLuid.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nReserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED), (int)8);
    }

    public static byte nReserved(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED + Checks.check((int)index, (int)8) * 1L);
    }

    static {
        Struct.Layout layout = OVRGraphicsLuid.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRGraphicsLuid.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<OVRGraphicsLuid, Buffer>
    implements NativeResource {
        private static final OVRGraphicsLuid ELEMENT_FACTORY = OVRGraphicsLuid.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRGraphicsLuid getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[8]")
        public ByteBuffer Reserved() {
            return OVRGraphicsLuid.nReserved(this.address());
        }

        @NativeType(value="char")
        public byte Reserved(int index) {
            return OVRGraphicsLuid.nReserved(this.address(), index);
        }
    }
}

